clear

set more off

import delimited "iri_wm_latlon15.csv"

gen own = string(lat_own)+","+string(lon_own)
forvalues i=1/24 {
gen wm`i' = string(wm_lat`i')+","+string(wm_lon`i')
replace wm`i' = "" if wm`i' == ".,."
drop wm_lat`i' wm_lon`i'
}
drop lat_own lon_own

forvalues i=1/24 {
traveltime3, start(own) end(wm`i') units(imperial)
rename t_distance dis`i'
rename t_time time`i'
drop t_distance t_time t_status t_origin t_destination geoid
save "driving_times.dta", replace
}


